{**********************************************************************
{*
{* Teach uEvent -- Version 3.0  (implemenation)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the code which implements the 
{* main event loop used by the Teach program.
{*
{**********************************************************************}
{$R-}


PROCEDURE Debug;  INLINE $0000;

{*******************************************************************}
{
{ CheckFrontW
{
{ This routine checks the front window to see if any changes need
{ to be made to the menu items.
{
{ We do this so that the edit items are only active when a desk
{ accessory is active.
{
{*******************************************************************}
procedure CheckFrontW;

var 
    theWindow    : GrafPortPtr;

    procedure   EnableDAItems;
        begin
            EnableMItem(UndoItem);
            EnableMItem(CloseItem);
            SetMenuFlag ($FF7F,EditMenuID);   { enable the edit menu }
        end;
    procedure   EnableAppItems;
        begin
            EnableMItem(SelectAllItem);
            EnableMItem(CloseItem);
            EnableMItem(SaveItem);
            EnableMItem(SaveAsItem);
            EnableMItem(PageSetupItem);
            EnableMItem(PrintItem);
            SetMenuFlag ($FF7F,SizeMenuID);   { enable the size menu }
            SetMenuFlag ($FF7F,StyleMenuID);   { enable the style menu }
            SetMenuFlag ($FF7F,FontMenuID);   { enable the font menu }
            SetMenuFlag ($FF7F,EditMenuID);   { enable the edit menu }
        end;
    procedure   DisableDAItems;
        begin
            DisableMItem(UndoItem);
        end;
    procedure   DisableAppItems;
        begin
            SetMenuFlag ($0080,FontMenuID);   { disable the font menu }
            SetMenuFlag ($0080,StyleMenuID);   { disable the style menu }
            SetMenuFlag ($0080,SizeMenuID);   { disable the size menu }
            DisableMItem(SaveItem);
            DisableMItem(SaveAsItem);
            DisableMItem(PageSetupItem);
            DisableMItem(PrintItem);
            DisableMItem(SelectAllItem);
        end;

begin   {of CheckFrontW}
    { Get the front window into local storage.}
    theWindow := FrontWindow;
    
    { If the LastWindow is this window, we are all set. }
    if theWindow = lastWindow then Exit(CheckFrontW);
    
    { If there are no windows, everything should be disabled }
    if theWindow = nil then 
        begin
            disableDAItems;
            disableAppItems;
            DisableMItem(CloseItem);
        end 
    else
        begin
            
            { Now look at what kind of window we have...}
            if GetSysWFlag (theWindow) then 
                begin   {Set up for da windows}
                    disableAppItems;
                    enableDAItems;
                end
            else
                begin   {Set up for our windows}
                    disableDAItems;
                    enableAppItems;
                end;
        end;
    
    { Remember this for next time. }
    DrawMenuBar;
    lastWindow := theWindow;
end;    {of CheckFrontW}





{************************************************************************
{
{ MainEvent
{
{ This is the main part of the program.  The program cycles in this
{ loop until the user choose select.
{
{************************************************************************}
procedure mainEvent;


var 
    code : integer;


begin   {of MainEvent}

   repeat
       checkFrontW;
       code := TaskMaster ($FFFF,event);
       case code of
           wInGoAway    : doCloseTop;
           wInSpecial,
           wInMenuBar   : doMenu;
       end;
   until quitFlag;
end;    {of MainEvent}
